'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/AssetManifest.bin": "7a68870b916b4603d27efe2b3a8938ca",
"assets/AssetManifest.bin.json": "a9456b21abd5db915568f66211edd380",
"assets/AssetManifest.json": "8969ee002d52a21893b8a5b4e59b951a",
"assets/assets/images/1.0x/album.webp": "95f46cfae41e3b435d23f07a75c8e77b",
"assets/assets/images/1.0x/call.webp": "b8966be8f422ce88950374f92e49fb1a",
"assets/assets/images/1.0x/certificate.webp": "d37b157d1761f574fff35dca46fd7074",
"assets/assets/images/1.0x/github.webp": "90af21c0bd816319e93d911d8590ff4a",
"assets/assets/images/1.0x/hireme.webp": "6fe64541ea6ba9e886c9385004d4c60b",
"assets/assets/images/1.0x/instagram.webp": "52800ae5e92cc88e4ce699d8107b9d6c",
"assets/assets/images/1.0x/linkedin.webp": "4296ffed1afa1ee3b37ae9200d71f66a",
"assets/assets/images/1.0x/projects.webp": "f354b39fbc73530bc51ed4b0484bb6ef",
"assets/assets/images/1.0x/resume.webp": "a9bfd04b64f4eb381106e33de259eac6",
"assets/assets/images/1.0x/x.webp": "fc8544809f0e57cffa1c11ffafed13b9",
"assets/assets/images/2.0x/album.webp": "1c7af26d52fa5a936a3d7ba1d66a5465",
"assets/assets/images/2.0x/call.webp": "a998a154b8a3dd1763915ecf72081c2a",
"assets/assets/images/2.0x/certificate.webp": "3b7039f4a5a0354592f0947d4337751b",
"assets/assets/images/2.0x/github.webp": "a073c2f140807556a6002994f155cdbf",
"assets/assets/images/2.0x/hireme.webp": "04f705ad23c5b65ebe3dee7f672a74b2",
"assets/assets/images/2.0x/instagram.webp": "da765849484a17232cd5d5190ff23647",
"assets/assets/images/2.0x/linkedin.webp": "c0ae7baf961fe7b2d06d81cb1deb7f6e",
"assets/assets/images/2.0x/projects.webp": "1e5eae6c66036641d8064bcd99a2675d",
"assets/assets/images/2.0x/resume.webp": "6b2d8f46811b748bcbd5fa6c27cc33a5",
"assets/assets/images/2.0x/x.webp": "6c0181275fd2a253f53181b424b3fef8",
"assets/assets/images/3.0x/album.webp": "d71bd6bb06dd740387ade3932b536187",
"assets/assets/images/3.0x/call.webp": "0fabc2bb2d934d612bb1d2f384029f03",
"assets/assets/images/3.0x/certificate.webp": "07bc5ef3a3aa9dcc7678f039ab05d9e4",
"assets/assets/images/3.0x/github.webp": "77dde924bfe906a172eeca57271a8dc6",
"assets/assets/images/3.0x/hireme.webp": "cb7c173337ff6b98a0ec002624444920",
"assets/assets/images/3.0x/instagram.webp": "34b680147a4e41d39f33d7826b47499f",
"assets/assets/images/3.0x/linkedin.webp": "0c4388b43fa68365cdca0c450db5614f",
"assets/assets/images/3.0x/projects.webp": "125c2318faa70526e0927011a140b20b",
"assets/assets/images/3.0x/resume.webp": "2579645ca2dd4569d641d50edf552d4f",
"assets/assets/images/3.0x/x.webp": "5b0eb2af27d0f865fe5ca83426df9c10",
"assets/assets/images/4.0x/album.webp": "22f935c73dac3a07832f5fa52fe2292d",
"assets/assets/images/4.0x/call.webp": "73ae4a70fb08401f24b1a2830d216515",
"assets/assets/images/4.0x/certificate.webp": "d68cd4e26864b78bf37656579521d007",
"assets/assets/images/4.0x/github.webp": "a503e50e0ec14c48f884bbeb4e84c920",
"assets/assets/images/4.0x/hireme.webp": "f1553e305d7cc3d9f1642f078131a3af",
"assets/assets/images/4.0x/instagram.webp": "653e74c9fc91cad0721bae70b8a51978",
"assets/assets/images/4.0x/linkedin.webp": "ab239e03dcd5ab5a980eebc27ed34c6a",
"assets/assets/images/4.0x/projects.webp": "e1e58e6418975ce3ca4547db00537990",
"assets/assets/images/4.0x/resume.webp": "3c7ea7c475d291920134c47b45928c99",
"assets/assets/images/4.0x/x.webp": "3420284fbde108cda48b0a9605ce7c5d",
"assets/assets/images/album.webp": "22f935c73dac3a07832f5fa52fe2292d",
"assets/assets/images/call.webp": "73ae4a70fb08401f24b1a2830d216515",
"assets/assets/images/certificate.webp": "d68cd4e26864b78bf37656579521d007",
"assets/assets/images/github.webp": "a503e50e0ec14c48f884bbeb4e84c920",
"assets/assets/images/hireme.webp": "f1553e305d7cc3d9f1642f078131a3af",
"assets/assets/images/img.png": "a80cfd59c6c6784339e38e89aa7d1fc2",
"assets/assets/images/instagram.webp": "653e74c9fc91cad0721bae70b8a51978",
"assets/assets/images/linkedin.webp": "ab239e03dcd5ab5a980eebc27ed34c6a",
"assets/assets/images/main.webp": "de298d5d2c9019bb665d0fc9ca4eae51",
"assets/assets/images/projects.webp": "e1e58e6418975ce3ca4547db00537990",
"assets/assets/images/resume.webp": "3c7ea7c475d291920134c47b45928c99",
"assets/assets/images/ss.jpeg": "2b7c9590eb144297f82d72aa3ff34dc4",
"assets/assets/images/x.webp": "3420284fbde108cda48b0a9605ce7c5d",
"assets/assets/sounds/typing_sound.mp3": "41081b9d85cb07431dd8a6ec3e9d3145",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/fonts/MaterialIcons-Regular.otf": "62e60d4f79a437263c99a35309087e58",
"assets/NOTICES": "04b2ab243d46be19449dd6fc52d68a35",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "e986ebe42ef785b27164c36a9abc7818",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"canvaskit/canvaskit.js": "738255d00768497e86aa4ca510cce1e1",
"canvaskit/canvaskit.js.symbols": "74a84c23f5ada42fe063514c587968c6",
"canvaskit/canvaskit.wasm": "9251bb81ae8464c4df3b072f84aa969b",
"canvaskit/chromium/canvaskit.js": "901bb9e28fac643b7da75ecfd3339f3f",
"canvaskit/chromium/canvaskit.js.symbols": "ee7e331f7f5bbf5ec937737542112372",
"canvaskit/chromium/canvaskit.wasm": "399e2344480862e2dfa26f12fa5891d7",
"canvaskit/skwasm.js": "5d4f9263ec93efeb022bb14a3881d240",
"canvaskit/skwasm.js.symbols": "c3c05bd50bdf59da8626bbe446ce65a3",
"canvaskit/skwasm.wasm": "4051bfc27ba29bf420d17aa0c3a98bce",
"canvaskit/skwasm.worker.js": "bfb704a6c714a75da9ef320991e88b03",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"flutter.js": "383e55f7f3cce5be08fcf1f3881f585c",
"flutter_bootstrap.js": "73c075b4217743b89a8803ef2c70da69",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"index.html": "04fd384991bba4ff36c1c924de673bbc",
"/": "04fd384991bba4ff36c1c924de673bbc",
"main.dart.js": "d98199ccf8cce2a336e124676a96b7d6",
"manifest.json": "bc61a833de53fc64ea487dbe67667a68",
"version.json": "d9b3b4106bfa1fe9bdbc242c569e0055"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
